import { BlockEnum } from '../../types'
import type { LLMNodeType } from './types'
import { Resolution } from '@/types/app'

export const mockData: LLMNodeType = {
  title: 'Test',
  desc: 'Test',
  type: BlockEnum.LLM,
  model: {
    provider: 'openai',
    name: 'gpt-4',
    mode: 'chat',
    completion_params: {
      temperature: 0.7,
    },
  },
  variables: [
    {
      variable: 'name',
      value_selector: ['aaa', 'name'],
    },
    {
      variable: 'age',
      value_selector: ['bbb', 'b', 'c'],
    },
  ],
  prompt: [],
  memory: {
    role_prefix: {
      user: 'user: ',
      assistant: 'assistant: ',
    },
    window: {
      enabled: false,
      size: 0,
    },
  },
  context: {
    enabled: false,
    variable_selector: ['aaa', 'name'],
  },
  vision: {
    enabled: false,
    variable_selector: [],
    configs: {
      detail: Resolution.low,
    },
  },
}
