import logging

from core.entities.application_entities import ApplicationGenerateEntity
from core.helper import moderation
from core.model_runtime.entities.message_entities import PromptMessage

logger = logging.getLogger(__name__)


class HostingModerationFeature:
    def check(self, application_generate_entity: ApplicationGenerateEntity,
              prompt_messages: list[PromptMessage]) -> bool:
        """
        Check hosting moderation
        :param application_generate_entity: application generate entity
        :param prompt_messages: prompt messages
        :return:
        """
        app_orchestration_config = application_generate_entity.app_orchestration_config_entity
        model_config = app_orchestration_config.model_config

        text = ""
        for prompt_message in prompt_messages:
            if isinstance(prompt_message.content, str):
                text += prompt_message.content + "\n"

        moderation_result = moderation.check_moderation(
            model_config,
            text
        )

        return moderation_result
