const isDevelopment = process.env.NODE_ENV === 'development';

export let apiPrefix = '';
let publicApiPrefix = '';

// NEXT_PUBLIC_API_PREFIX=/console/api NEXT_PUBLIC_PUBLIC_API_PREFIX=/api npm run start
if (process.env.NEXT_PUBLIC_API_PREFIX && process.env.NEXT_PUBLIC_PUBLIC_API_PREFIX) {
  apiPrefix = process.env.NEXT_PUBLIC_API_PREFIX;
  publicApiPrefix = process.env.NEXT_PUBLIC_PUBLIC_API_PREFIX;
} else if (
  globalThis.document?.body?.getAttribute('data-api-prefix') &&
  globalThis.document?.body?.getAttribute('data-pubic-api-prefix')
) {
  // Not bulild can not get env from process.env.NEXT_PUBLIC_ in browser https://nextjs.org/docs/basic-features/environment-variables#exposing-environment-variables-to-the-browser
  apiPrefix = globalThis.document.body.getAttribute('data-api-prefix') as string
  publicApiPrefix = globalThis.document.body.getAttribute('data-pubic-api-prefix') as string
} else {
  if (isDevelopment) {
    apiPrefix = 'https://cloud.dify.dev/console/api';
    publicApiPrefix = 'https://dev.udify.app/api';
  } else {
    // const domainParts = globalThis.location?.host?.split('.');
    // in production env, the host is dify.app . In other env, the host is [dev].dify.app
    // const env = domainParts.length === 2 ? 'ai' : domainParts?.[0];
    apiPrefix = '/console/api';
    publicApiPrefix = `/api`; // avoid browser private mode api cross origin
  }
}


export const API_PREFIX: string = apiPrefix;
export const PUBLIC_API_PREFIX: string = publicApiPrefix;

// mock server
export const MOCK_API_PREFIX = 'http://127.0.0.1:3001'

const EDITION = process.env.NEXT_PUBLIC_EDITION || globalThis.document?.body?.getAttribute('data-public-edition')
export const IS_CE_EDITION = EDITION === 'SELF_HOSTED'

export const TONE_LIST = [
  {
    id: 1,
    name: 'Creative',
    config: {
      temperature: 0.8,
      top_p: 0.9,
      presence_penalty: 0.1,
      frequency_penalty: 0.1,
    },
  },
  {
    id: 2,
    name: 'Balanced',
    config: {
      temperature: 0.5,
      top_p: 0.85,
      presence_penalty: 0.2,
      frequency_penalty: 0.3,
    },
  },
  {
    id: 3,
    name: 'Precise',
    config: {
      temperature: 0.2,
      top_p: 0.75,
      presence_penalty: 0.5,
      frequency_penalty: 0.5,
    },
  },
  {
    id: 4,
    name: 'Custom',
  },
]

export const LOCALE_COOKIE_NAME = 'locale'

export const DEFAULT_VALUE_MAX_LEN = 48

export const zhRegex = /^[\u4e00-\u9fa5]$/gm
export const emojiRegex = /^[\uD800-\uDBFF][\uDC00-\uDFFF]$/gm
export const emailRegex = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/
const MAX_ZN_VAR_NAME_LENGHT = 8
const MAX_EN_VAR_VALUE_LENGHT = 16
export const getMaxVarNameLength = (value: string) => {
  if (zhRegex.test(value)) {
    return MAX_ZN_VAR_NAME_LENGHT
  }
  return MAX_EN_VAR_VALUE_LENGHT
}

export const MAX_VAR_KEY_LENGHT = 16

export const VAR_ITEM_TEMPLATE = {
  key: '',
  name: '',
  type: 'string',
  max_length: DEFAULT_VALUE_MAX_LEN,
  required: true
}



