package cn.breeze.elleai.application.dto.inner;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 考试流水缓存
 */
@Data
public class ExamineBusinessCacheDto implements Serializable {

    /**
     * 考试ID
     */
    @Schema(description = "考试ID")
    private Integer examineId;

    /**
     * 对练模式（0练习 1对练）
     */
    @Schema(description = "对练模式（0练习 1对练）")
    private Integer examineMode;

    /**
     * 用户ID
     */
    @Schema(description = "用户ID")
    private String userId;

    /**
     * 考试记录ID
     */
    @Schema(description = "考试记录ID")
    private Integer recordId;

    /**
     * 当前题目ID
     */
    @Schema(description = "当前题目ID")
    private Integer currentQuestionId;

    /**
     * 是否有下一题
     */
    @Schema(description = "是否有下一题")
    private boolean hasNext;
}
