package cn.breeze.elleai.application.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExamineQaSaveDto implements Serializable {

    @Schema(description = "题目ID")
    private Integer id;

    /**
     * 问题
     */
    @Schema(description = "问题")
    private String question;

    /**
     * 答案
     */
    @Schema(description = "答案")
    private String answer;

    /**
     * 对练分类ID
     */
    @Schema(description = "对练分类ID")
    @JsonProperty("category_id")
    private Integer categoryId;

    /**
     * 状态（0禁用 1启用）
     */
    @Schema(description = "状态（0禁用 1启用）")
    private Integer status;

}
