package cn.breeze.elleai.application.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExamineRecordRequestDto implements Serializable {

    @Schema(description = "页码")
    @JsonProperty("page_no")
    private Integer pageNo = 1;

    @Schema(description = "分页数量")
    @JsonProperty("page_size")
    private Integer pageSize = 10;

    @Schema(description = "用户ID")
    @JsonProperty("user_id")
    private String userId;

    @Schema(description = "考试ID")
    @JsonProperty("examine_id")
    private Integer examineId;

    @Schema(description = "对练模式（0练习 1对练）")
    @JsonProperty("examine_mode")
    private Integer examineMode;

    @Schema(description = "开始时间")
    @JsonProperty("start_time")
    private Date startTime;

    @Schema(description = "结束时间")
    @JsonProperty("end_time")
    private Date endTime;
}
