package cn.breeze.elleai.application.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class ExamineSceneCategorySaveDto implements Serializable {

    @Schema(description = "场景分类ID")
    private Integer id;

    /**
     * 分类名称
     */
    @Schema(description = "场景分类名称")
    private String name;

    /**
     * 场景ID
     */
    @Schema(description = "场景ID")
    @JsonProperty("scene_id")
    private Integer sceneId;

    @Schema(description = "可见角色列表")
    @JsonProperty("visible_role_list")
    private List<String> visibleRoleList;

    /**
     * 分类描述
     */
    @Schema(description = "场景分类描述")
    private String description;

    /**
     * 状态（0禁用 1启用）
     */
    @Schema(description = "状态（0禁用 1启用）")
    private Integer status;

    /**
     * 父级分类ID
     */
    @Schema(description = "父级分类ID")
    @JsonProperty("parent_id")
    private Integer parentId;

}
