package cn.breeze.elleai.application.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class QaAssistantSaveDto implements Serializable {

    @Schema(description = "助手ID")
    private Integer id;

    /**
     * 助手名称
     */
    @Schema(description = "助手名称")
    private String name;

    /**
     * 助手描述
     */
    @Schema(description = "助手描述")
    private String description;

    /**
     * 助手图标
     */
    @Schema(description = "助手图标")
    @JsonProperty("icon_url")
    private String iconUrl;

    @Schema(description = "知识库分类ID列表")
    @JsonProperty("category_id_list")
    private List<String> categoryIdList;

    @Schema(description = "可见角色列表")
    @JsonProperty("visible_role_list")
    private List<String> visibleRoleList;

}
