package cn.breeze.elleai.application.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

@Data
public class UserQaHistoryMobileRequestDto implements Serializable {

    @Schema(description = "页码")
    @JsonProperty("page_no")
    private Integer pageNo = 1;

    @Schema(description = "分页数量")
    @JsonProperty("page_size")
    private Integer pageSize = 10;

    @Schema(description = "用户ID")
    @JsonProperty("user_id")
    private String userId;

    @Schema(description = "会话ID")
    @JsonProperty("session_id")
    private String sessionId;

    @Schema(description = "内容")
    private String content;

    @Schema(description = "会话记录ID")
    @JsonProperty("chat_completion_id")
    private Integer chatCompletionId;
}
