package cn.breeze.elleai.application.dto.response;

import cn.breeze.elleai.domain.sparring.model.response.ExamineQaResponseModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class ExamineDto implements Serializable {

    @Schema(description = "对练ID")
    private Integer id;

    /**
     * 对练名称
     */
    @Schema(description = "对练名称")
    private String name;

    /**
     * 对练描述
     */
    @Schema(description = "对练描述")
    private String description;

    /**
     * 海报图
     */
    @Schema(description = "海报图")
    private String poster;

    /**
     * 对练场景ID
     */
    @Schema(description = "对练场景ID")
    @JsonProperty("scene_id")
    private Integer sceneId;

    /**
     * 对练分类ID
     */
    @Schema(description = "对练分类ID")
    @JsonProperty("category_id")
    private Integer categoryId;

    /**
     * 开始时间
     */
    @Schema(description = "开始时间")
    @JsonProperty("start_time")
    private Long startTime;

    /**
     * 结束时间
     */
    @Schema(description = "结束时间")
    @JsonProperty("end_time")
    private Long endTime;

    /**
     * 状态（0禁用 1启用）
     */
    @Schema(description = "状态（0禁用 1启用）")
    private Integer status;

    /**
     * 题目数量
     */
    @Schema(description = "题目数量")
    @JsonProperty("qa_num")
    private Integer qaNum;

    /**
     * 关联题目列表
     */
    @Schema(description = "关联题目列表")
    private List<ExamineQaResponseModel> qaList;
}
