package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class ExamineFinalResultDto implements Serializable {

    @Schema(description = "平均分")
    @JsonProperty("avg_score")
    private Double avgScore;

    @Schema(description = "总分")
    @JsonProperty("total_score")
    private Double totalScore;

    @Schema(description = "考试总点评")
    @JsonProperty("exam_criteria")
    private String examCriteria;

    @Schema(description = "答题数量")
    @JsonProperty("answered_num")
    private Integer answeredNum;

    @Schema(description = "答题明细列表")
    @JsonProperty("exam_detail_list")
    private List<ExamineDetailRecordMobileDto> examDetailList;

}
