package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

@Data
public class ExamineStartResultDto implements Serializable {

    @Schema(description = "考试流水号，答题、结束考试都需要传此参数")
    @JsonProperty("business_no")
    private String businessNo;

    @Schema(description = "题目ID")
    @JsonProperty("question_id")
    private Integer questionId;

    @Schema(description = "问题")
    private String question;

    @Schema(description = "标准答案")
    private String answer;

    @Schema(description = "是否有下一题")
    private boolean next;
}
