package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class QaAssistantDto implements Serializable {

    @Schema(description = "助手ID")
    private Integer id;

    /**
     * 助手名称
     */
    @Schema(description = "助手名称")
    private String name;

    /**
     * 助手描述
     */
    @Schema(description = "助手描述")
    private String description;

    /**
     * 助手图标
     */
    @Schema(description = "助手图标")
    @JsonProperty("icon_url")
    private String iconUrl;

    @Schema(description = "知识库分类ID列表")
    @JsonProperty("category_id_list")
    private List<String> categoryIdList;

    @Schema(description = "可见角色列表")
    @JsonProperty("visible_role_list")
    private List<String> visibleRoleList;

    /**
     * 状态（0禁用 1启用）
     */
    @Schema(description = "状态（0禁用 1启用）")
    private Integer status;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonProperty("create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @JsonProperty("update_time")
    private Date updateTime;
}
