package cn.breeze.elleai.application.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class UserChatCompletionDto implements Serializable {

    @Schema(description = "会话记录ID")
    private Integer id;

    /**
     * 用户ID
     */
    @Schema(description = "用户ID")
    @JsonProperty("user_id")
    private String userId;

    /**
     * 用户名称
     */
    @Schema(description = "用户名称")
    @JsonProperty("user_name")
    private String userName;

    /**
     * 所属门店ID
     */
    @Schema(description = "所属门店ID")
    @JsonProperty("shop_id")
    private String shopId;

    /**
     * 所属门店名称
     */
    @Schema(description = "所属门店名称")
    @JsonProperty("shop_name")
    private String shopName;

    /**
     * 会话ID
     */
    @Schema(description = "DIFY会话ID")
    @JsonProperty("session_id")
    private String sessionId;

    /**
     * 首次提问
     */
    @Schema(description = "首次提问")
    @JsonProperty("first_question")
    private String firstQuestion;

    /**
     * 最后一次提问
     */
    @Schema(description = "最后提问")
    @JsonProperty("last_question")
    private String lastQuestion;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @JsonProperty("create_time")
    private Date createTime;

    /**
     * 最后更新时间
     */
    @Schema(description = "更新时间")
    @JsonProperty("update_time")
    private Date updateTime;
}
