package cn.breeze.elleai.application.service;


import cn.breeze.elleai.application.dto.inner.AiSingleEvaluateResultDto;
import com.alibaba.fastjson2.JSONObject;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * AI平台扩展服务
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class AiPlatformExtensionService {

    @Value("${dify.api_base}")
    private String difyBase;

    @Value("${dify.api_key}")
    private String apiKey;

    private final RestTemplate restTemplate = new RestTemplate();


    /**
     * 单题评分+点评
     * @param sessionId
     * @param userId
     * @param question
     * @param answer
     * @param userAnswer
     */
    public AiSingleEvaluateResultDto run4SingleEvaluate(String sessionId, String userId, String question, String answer, String userAnswer) {
        Map<String, String> inputs = new HashMap<>();
        inputs.put("scene", "single_evaluate");
        inputs.put("question", question);
        inputs.put("answer", answer);
        inputs.put("user_answer", userAnswer);
        JSONObject param = new JSONObject();
        param.put("query", userAnswer);
        param.put("inputs", inputs);
        param.put("response_mode", "blocking");
        param.put("conversation_id", "");
        param.put("user", userId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(apiKey);

        log.info("异步请求参数1，sessionId = {}", sessionId);
        log.info("异步请求参数2，req = {}", JSONObject.toJSONString(param));
        HttpEntity<String> postEntity = new HttpEntity<>(param.toJSONString(), headers);
        ResponseEntity<String> response = restTemplate.postForEntity(difyBase + "/chat-messages", postEntity, String.class);

        String body = response.getBody();
        log.info("执行结果：{}", body);
        if(Objects.equals(response.getStatusCode(), HttpStatus.OK)) {
            JSONObject bodyObject = JSONObject.parseObject(body);
            String conversationId = bodyObject.getString("conversation_id");
            JSONObject answerObject = JSONObject.parseObject(bodyObject.getString("answer"));
            Float score = answerObject.getFloat("score");
            String evaluation = answerObject.getString("evaluation");

            AiSingleEvaluateResultDto result = new AiSingleEvaluateResultDto();
            result.setEvaluation(evaluation);
            result.setScore(score);
            result.setDifySessionId(conversationId);
            return result;
        }
        return null;
    }

    /**
     * 考试总点评
     * @param sessionId
     * @param userId
     * @param businessNo
     */
    public String run4TotalEvaluate(String sessionId, String userId, String businessNo) {
        Map<String, Object> inputs = new HashMap<>();
        inputs.put("scene", "total_evaluate");
        inputs.put("business_no", businessNo);
        JSONObject param = new JSONObject();
        param.put("query", businessNo);
        param.put("inputs", inputs);
        param.put("response_mode", "blocking");
        param.put("conversation_id", "");
        param.put("user", userId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(apiKey);

        log.info("异步请求参数1，sessionId = {}", sessionId);
        log.info("异步请求参数2，req = {}", JSONObject.toJSONString(param));
        HttpEntity<String> postEntity = new HttpEntity<>(param.toJSONString(), headers);
        ResponseEntity<String> response = restTemplate.postForEntity(difyBase + "/chat-messages", postEntity, String.class);

        String body = response.getBody();
        log.info("执行结果：{}", body);
        if(Objects.equals(response.getStatusCode(), HttpStatus.OK)) {
            JSONObject bodyObject = JSONObject.parseObject(body);
            String conversationId = bodyObject.getString("conversation_id");
            JSONObject answerObject = JSONObject.parseObject(bodyObject.getString("answer"));
            String evaluation = answerObject.getString("evaluation");
            return evaluation;
        }
        return null;
    }
}
