package cn.breeze.elleai.application.service;

import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.ProperNounRequestDto;
import cn.breeze.elleai.application.dto.request.ProperNounSaveDto;
import cn.breeze.elleai.application.dto.response.AppRoleDto;
import cn.breeze.elleai.application.dto.response.KnowledgeDataBaseCategoryDto;
import cn.breeze.elleai.application.dto.response.ProperNounDto;
import cn.breeze.elleai.domain.sparring.model.request.ProperNounRequestModel;
import cn.breeze.elleai.domain.sparring.model.request.ProperNounSaveModel;
import cn.breeze.elleai.domain.sparring.model.response.DataDicResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.ProperNounResponseModel;
import cn.breeze.elleai.domain.sparring.service.CommonService;
import cn.breeze.elleai.util.Codes;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 应用服务
 */
@Component
@RequiredArgsConstructor
public class AppCommonService {
    
    private final CommonService commonService;
    
    /************************************************** 专有名词 **************************************************/

    /**
     * 更新专有名词
     * @param id
     * @param status
     */
    public void updateProperNounStatus(Integer id, Integer status) {
        commonService.updateProperNounStatus(id, status);
    }

    /**
     * 删除专有名词
     * @param id
     */
    public void deleteProperNoun(Integer id) {
        commonService.deleteProperNoun(id);
    }

    /**
     * 获取专有名词详情
     * @param id
     * @return
     */
    public ProperNounDto properNounDetail(Integer id) {
        ProperNounResponseModel model = commonService.properNounDetail(id);
        ProperNounDto result = BeanUtil.copyProperties(model, ProperNounDto.class);
        if(StrUtil.isNotEmpty(model.getSimilarWords())) {
            result.setSimilarWordList(JSONObject.parseArray(model.getSimilarWords(), String.class));
        }
        return result;
    }


    /**
     * 保存专有名词
     * @param dto
     */
    public void saveproperNoun(ProperNounSaveDto dto) {

        ProperNounSaveModel model = BeanUtil.copyProperties(dto, ProperNounSaveModel.class);
        model.setSimilarWords(JSON.toJSONString(dto.getSimilarWordList()));
        commonService.saveProperNoun(model);
    }


    /**
     * 专有名词分页查询
     * @param request
     * @return
     */
    public PageResult<ProperNounDto> properNounPaginQuery(ProperNounRequestDto request) {

        ProperNounRequestModel requestModel = BeanUtil.copyProperties(request, ProperNounRequestModel.class);

        Page<ProperNounResponseModel> page = commonService.properNounPaginQuery(requestModel);

        PageResult<ProperNounDto> pageResult = PageResult.of(request.getPageNo(), request.getPageSize(), (int) page.getTotalRow(), null);

        if(CollectionUtil.isNotEmpty(page.getRecords())) {
            List<ProperNounDto> dtoList = page.getRecords().stream().map(v -> {
                ProperNounDto dto = BeanUtil.copyProperties(v, ProperNounDto.class);

                if(StrUtil.isNotEmpty(v.getSimilarWords())) {
                    dto.setSimilarWordList(JSONObject.parseArray(v.getSimilarWords(), String.class));
                }
                return dto;
            }).collect(Collectors.toList());

            pageResult.setItems(dtoList);
        }
        return pageResult;
    }

    /**
     * 知识库分类列表
     * @return
     */
    public List<KnowledgeDataBaseCategoryDto> KnowledgeDataBaseCategoryList() {

        DataDicResponseModel dataDicByCode = commonService.getDataDicByCode(Codes.DATA_DIC_KDB_CATEGORY_LIST);
        if(Objects.nonNull(dataDicByCode) && StrUtil.isNotEmpty(dataDicByCode.getDataValue())) {
            return JSONObject.parseArray(dataDicByCode.getDataValue(), KnowledgeDataBaseCategoryDto.class);
        }
        return null;
    }

    /**
     * APP角色列表
     * @return
     */
    public List<AppRoleDto> appRoleList() {

        DataDicResponseModel dataDicByCode = commonService.getDataDicByCode(Codes.DATA_DIC_APP_ROLE_LIST);
        if(Objects.nonNull(dataDicByCode) && StrUtil.isNotEmpty(dataDicByCode.getDataValue())) {
            return JSONObject.parseArray(dataDicByCode.getDataValue(), AppRoleDto.class);
        }
        return null;
    }
}
