package cn.breeze.elleai.config;

import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.exception.InternalException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * 请求接口处理
 * @author Administrator
 */
//@RestControllerAdvice
@Slf4j
public class GlobalExceptionHandler {

    @ExceptionHandler(InternalException.class)
    public ResponseEntity<ApiResponse> handleException(InternalException e) {
        e.printStackTrace();
        log.error("出错啦：ex = {}, message = {}", e.getDescription(), e.getStackTrace());
        ApiResponse error = ApiResponse.fail(e.getCode(), e.getDescription());
        return new ResponseEntity<>(error, HttpStatus.OK);
    }


    @ExceptionHandler(Exception.class)
    public ResponseEntity<ApiResponse> handleException(Exception e) {
        e.printStackTrace();
        log.error("出错啦：ex = {}, message = {}", e.getMessage(), e.getStackTrace());
        ApiResponse error = ApiResponse.fail(-1, e.getMessage());
        return new ResponseEntity<>(error, HttpStatus.OK);
    }



}
