package cn.breeze.elleai.config;

import org.springframework.stereotype.Component;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;

/**
 * @author yangyw
 * @create at 2023-10-12 18:33
 **/
@Component
public class GlobalWebWebConfigurer implements WebMvcConfigurer {

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        QueryParamHandlerMethodArgumentResolver queryParamHandlerMethodArgumentResolver = new QueryParamHandlerMethodArgumentResolver();
        resolvers.add(queryParamHandlerMethodArgumentResolver);

        UserPrincipalHandlerMethodArgumentResolver userPrincipalHandlerMethodArgumentResolver = new UserPrincipalHandlerMethodArgumentResolver();
        resolvers.add(userPrincipalHandlerMethodArgumentResolver);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new QueryParamHandlerMethodArgumentResolver());
    }
}

