package cn.breeze.elleai.config;

import cn.breeze.elleai.job.SingleJob;
import lombok.SneakyThrows;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;

@Configuration
public class QuartzCronConfig {

    @Bean
    public JobDetail jobDetail() {
        JobDetailFactoryBean factoryBean = new JobDetailFactoryBean();
        factoryBean.setJobClass(SingleJob.class); // 可以使用同一个任务类
        factoryBean.setDurability(true);
        factoryBean.setName("cronJob");
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }

    @SneakyThrows
    @Bean
    public Trigger cronTrigger(JobDetail jobDetail) {
        CronTriggerFactoryBean factoryBean = new CronTriggerFactoryBean();
        factoryBean.setJobDetail(jobDetail);
        factoryBean.setCronExpression("0 0/1 * * * ?"); // 每5分钟执行一次
        factoryBean.setName("cronTrigger");
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }
}
