package cn.breeze.elleai.config;

import cn.breeze.elleai.util.Codes;
import cn.breeze.elleai.util.JwtUtil;
import cn.breeze.elleai.util.PrincipalEnum;
import cn.breeze.elleai.util.UserPrincipal;
import cn.hutool.core.util.StrUtil;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import reactor.core.publisher.Mono;

import java.util.Objects;

/**
 *
 * 用户身份解析请求参数的自定义解析器
 * @author Administrator
 */
public class UserPrincipalHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver {


    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(UserPrincipal.class);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {

        HttpServletRequest request = webRequest.getNativeRequest(HttpServletRequest.class);
        UserPrincipal userPrincipal = null;
        Mono<Authentication> convert = JwtUtil.convert(request);
        Authentication authentication = convert.toFuture().get();
        if(Objects.nonNull(authentication)) {
            userPrincipal = (UserPrincipal) authentication.getPrincipal();
        }
        return userPrincipal;
    }
}
