package cn.breeze.elleai.controller.admin;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.ProperNounRequestDto;
import cn.breeze.elleai.application.dto.request.ProperNounSaveDto;
import cn.breeze.elleai.application.dto.response.AppRoleDto;
import cn.breeze.elleai.application.dto.response.KnowledgeDataBaseCategoryDto;
import cn.breeze.elleai.application.dto.response.ProperNounDto;
import cn.breeze.elleai.application.service.AppCommonService;
import cn.breeze.elleai.config.QueryParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/admin/common")
@Tag(name = "管理端-公共服务", description = "公共服务")
@RequiredArgsConstructor
public class CommonController {

    private final AppCommonService commonService;


    @Operation(summary = "专有名词详情")
    @GetMapping("/proper_noun/detail/{id}")
    public ApiResponse<ProperNounDto> detail(@Schema(description = "专有名词ID") @PathVariable("id") Integer id) {
        ProperNounDto detail = commonService.properNounDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "启用/禁用专有名词")
    @PostMapping("/proper_noun/update_status/{id}/{status}")
    public ApiResponse<String> updateStatus(@Schema(description = "专有名词ID") @PathVariable("id") Integer id,
                                            @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
        commonService.updateProperNounStatus(id, status);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "删除专有名词")
    @PostMapping("/proper_noun/delete/{id}")
    public ApiResponse<String> delete(@Schema(description = "专有名词ID") @PathVariable("id") Integer id) {
        commonService.deleteProperNoun(id);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "保存专有名词")
    @PostMapping("/proper_noun/save")
    public ApiResponse<String> saveOrUpdate(@RequestBody ProperNounSaveDto dto) {
        commonService.saveproperNoun(dto);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "专有名词列表")
    @GetMapping("/proper_noun/list")
    public ApiResponse<PageResult<ProperNounDto>> list(@QueryParam ProperNounRequestDto request) {
        PageResult<ProperNounDto> pageResult = commonService.properNounPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }


    @Operation(summary = "知识库分类列表")
    @GetMapping("/kdb_category/list")
    public ApiResponse<List<KnowledgeDataBaseCategoryDto>> kdbCategoryList() {
        List<KnowledgeDataBaseCategoryDto> result = commonService.KnowledgeDataBaseCategoryList();
        return ApiResponse.ok(result);
    }

    @Operation(summary = "伊丽汇APP角色列表")
    @GetMapping("/app_role/list")
    public ApiResponse<List<AppRoleDto>> appRoleList() {
        List<AppRoleDto> result = commonService.appRoleList();
        return ApiResponse.ok(result);
    }
}
