package cn.breeze.elleai.controller.admin;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.ExamineRecordRequestDto;
import cn.breeze.elleai.application.dto.request.ExamineRequestDto;
import cn.breeze.elleai.application.dto.request.ExamineSaveDto;
import cn.breeze.elleai.application.dto.response.ExamineDto;
import cn.breeze.elleai.application.dto.response.ExamineRecordDto;
import cn.breeze.elleai.application.dto.response.ExamineRecordMobileDto;
import cn.breeze.elleai.application.service.AppExamineService;
import cn.breeze.elleai.config.QueryParam;
import cn.breeze.elleai.util.UserPrincipal;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/admin/examine")
@Tag(name = "管理端-对练", description = "对练")
@RequiredArgsConstructor
public class ExamineController {

    private final AppExamineService examineService;


    @Operation(summary = "对练详情")
    @GetMapping("/detail/{id}")
    public ApiResponse<ExamineDto> detail(@Schema(description = "对练ID") @PathVariable("id") Integer id) {
        ExamineDto detail = examineService.examineDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "启用/禁用对练")
    @PostMapping("/update_status/{id}/{status}")
    public ApiResponse<String> updateStatus(@Schema(description = "对练ID") @PathVariable("id") Integer id,
                                            @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
        examineService.updateExamineStatus(id, status);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "删除对练")
    @PostMapping("/delete/{id}")
    public ApiResponse<String> delete(@Schema(description = "对练ID") @PathVariable("id") Integer id) {
        examineService.deleteExamine(id);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "保存对练")
    @PostMapping("/save")
    public ApiResponse<String> saveOrUpdate(@RequestBody ExamineSaveDto dto) {
        examineService.saveExamine(dto);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "对练列表")
    @GetMapping("/list")
    public ApiResponse<PageResult<ExamineDto>> list(@QueryParam ExamineRequestDto request) {
        PageResult<ExamineDto> pageResult = examineService.examinePaginQuery(request);
        return ApiResponse.ok(pageResult);
    }

    @Operation(summary = "对练记录详情", tags = "对练记录")
    @GetMapping("/record/detail/{id}")
    public ApiResponse<ExamineRecordDto> recordDetail(@Schema(description = "对练记录ID") @PathVariable("id") Integer id) {
        ExamineRecordDto detail = examineService.examineRecordDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "对练记录列表", tags = "对练记录")
    @GetMapping("/record/list")
    public ApiResponse<PageResult<ExamineRecordDto>> recordList(@QueryParam ExamineRecordRequestDto request) {
        PageResult<ExamineRecordDto> pageResult = examineService.examineRecordPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }
}
