package cn.breeze.elleai.controller.admin;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.ExamineQaRequestDto;
import cn.breeze.elleai.application.dto.request.ExamineQaSaveDto;
import cn.breeze.elleai.application.dto.response.ExamineQaDto;
import cn.breeze.elleai.application.service.AppExamineService;
import cn.breeze.elleai.config.QueryParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

/**
 * 对练QA
 */
@RestController
@RequestMapping(value = "/admin/examine/qa")
@Tag(name = "管理端-对练题目", description = "对练题目")
@RequiredArgsConstructor
public class ExamineQaController {

    private final AppExamineService examineService;


    @Operation(summary = "对练题目详情")
    @GetMapping("/detail/{id}")
    public ApiResponse<ExamineQaDto> detail(@Schema(description = "题目ID") @PathVariable("id") Integer id) {
        ExamineQaDto detail = examineService.qaDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "启用/禁用对练题目")
    @PostMapping("/update_status/{id}/{status}")
    public ApiResponse<String> updateStatus(@Schema(description = "题目ID") @PathVariable("id") Integer id,
                                            @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
        examineService.updateQaStatus(id, status);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "删除对练题目")
    @PostMapping("/delete/{id}")
    public ApiResponse<String> delete(@Schema(description = "题目ID") @PathVariable("id") Integer id) {
        examineService.deleteQa(id);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "保存对练题目")
    @PostMapping("/save")
    public ApiResponse<String> saveOrUpdate(@RequestBody ExamineQaSaveDto dto) {
        examineService.saveExamineQa(dto);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "对练题目列表")
    @GetMapping("/list")
    public ApiResponse<PageResult<ExamineQaDto>> list(@QueryParam ExamineQaRequestDto request) {
        PageResult<ExamineQaDto> pageResult = examineService.examineQaPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }
}
