package cn.breeze.elleai.controller.admin;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.*;
import cn.breeze.elleai.application.dto.response.WikiCategoryDto;
import cn.breeze.elleai.application.dto.response.WikiDto;
import cn.breeze.elleai.application.service.AppExamineService;
import cn.breeze.elleai.config.QueryParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/admin/wiki")
@Tag(name = "管理端-资料库", description = "资料库")
@RequiredArgsConstructor
public class WikiController {

    private final AppExamineService examineService;


    @Operation(summary = "资料库详情")
    @GetMapping("/detail/{id}")
    public ApiResponse<WikiDto> detail(@Schema(description = "资料ID") @PathVariable("id") Integer id) {
        WikiDto detail = examineService.wikiDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "启用/禁用资料库")
    @PostMapping("/update_status/{id}/{status}")
    public ApiResponse<String> updateStatus(@Schema(description = "资料ID") @PathVariable("id") Integer id,
                                            @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
        examineService.updateWikiStatus(id, status);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "删除资料库")
    @PostMapping("/delete/{id}")
    public ApiResponse<String> delete(@Schema(description = "资料ID") @PathVariable("id") Integer id) {
        examineService.deleteWiki(id);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "保存资料库")
    @PostMapping("/save")
    public ApiResponse<String> saveOrUpdate(@RequestBody WikiSaveDto dto) {
        examineService.saveWiki(dto);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "资料库列表")
    @GetMapping("/list")
    public ApiResponse<PageResult<WikiDto>> list(@QueryParam WikiRequestDto request) {
        PageResult<WikiDto> pageResult = examineService.wikiPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }

    @Operation(summary = "资料库分类详情")
    @GetMapping("/category/detail/{id}")
    public ApiResponse<WikiCategoryDto> categoryDetail(@Schema(description = "资料分类ID") @PathVariable("id") Integer id) {
        WikiCategoryDto detail = examineService.wikiCategoryDetail(id);
        return ApiResponse.ok(detail);
    }

    @Operation(summary = "启用/禁用资料库分类")
    @PostMapping("/category/update_status/{id}/{status}")
    public ApiResponse<String> updateCategoryStatus(@Schema(description = "资料分类ID") @PathVariable("id") Integer id,
                                                    @Schema(description = "状态（0禁用 1启用）") @PathVariable("status") Integer status) {
        examineService.updateWikiCategoryStatus(id, status);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "删除资料库分类")
    @PostMapping("/category/delete/{id}")
    public ApiResponse<String> deleteCategory(@Schema(description = "资料分类ID") @PathVariable("id") Integer id) {
        examineService.deleteWikiCategory(id);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "保存资料库分类")
    @PostMapping("/category/save")
    public ApiResponse<String> saveOrUpdateCategory(@RequestBody WikiCategorySaveDto dto) {
        examineService.saveWikiCategory(dto);
        return ApiResponse.ok("ok");
    }

    @Operation(summary = "资料库分类列表")
    @GetMapping("/category/list")
    public ApiResponse<PageResult<WikiCategoryDto>> categoryList(@QueryParam WikiCategoryRequestDto request) {
        PageResult<WikiCategoryDto> pageResult = examineService.wikiCategoryPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }
}
