package cn.breeze.elleai.controller.extension;

import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.response.AppRoleDto;
import cn.breeze.elleai.application.service.AiPlatformExtensionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.UUID;

/**
 * @author yangyw
 */
@RestController
@RequestMapping(value = "/extension")
@Tag(name = "扩展接口-AI平台扩展")
@RequiredArgsConstructor
public class AiPlatformExtensionController {

    private final AiPlatformExtensionService extensionService;

    @Operation(summary = "单题点评")
    @GetMapping("/single_evaluate")
    public ApiResponse<String> singleEvaluate() {
        String userId = UUID.randomUUID().toString();
        String sessionId = UUID.randomUUID().toString();
        String question = "问题";
        String answer = "答案";
        String userAnswer = "用户答案";

        extensionService.run4SingleEvaluate(userId, sessionId, question, answer, userAnswer);
        return ApiResponse.ok("SUCCESS");
    }

    @Operation(summary = "单题点评")
    @GetMapping("/total_evaluate")
    public ApiResponse<String> totalEvaluate() {
        String userId = UUID.randomUUID().toString();
        String sessionId = UUID.randomUUID().toString();

        extensionService.run4TotalEvaluate(sessionId, userId, null);
        return ApiResponse.ok("SUCCESS");
    }
}
