package cn.breeze.elleai.controller.front;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.*;
import cn.breeze.elleai.application.dto.response.*;
import cn.breeze.elleai.application.service.AppChatCompletionService;
import cn.breeze.elleai.config.QueryParam;
import cn.breeze.elleai.util.UserPrincipal;
import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/front/chat")
@Tag(name = "移动端-AI问答")
@RequiredArgsConstructor
public class ChatCompletionMobileController {

    private final AppChatCompletionService chatCompletionService;

    @Operation(summary = "助手列表")
    @GetMapping("/assistant/list")
    public ApiResponse<PageResult<QaAssistantDto>> assistantList(@QueryParam QaAssistantRequestDto request) {
        PageResult<QaAssistantDto> pageResult = chatCompletionService.qaAssistantPaginQuery(request);
        return ApiResponse.ok(pageResult);
    }

    @Operation(summary = "热门提问")
    @GetMapping("/hot/list")
    public ApiResponse<PageResult<HotQaMobileDto>> hotList(@QueryParam QaAssistantRequestDto request) {
        PageResult<HotQaMobileDto> pageResult = new PageResult<>();
        String json = "{\"items\": [{\"question\": \"热门提问1\"},{\"question\": \"热门提问2\"},{\"question\": \"热门提问3\"},{\"question\": \"热门提问4\"},{\"question\": \"热门提问5\"},{\"question\": \"热门提问6\"},{\"question\": \"热门提问7\"},{\"question\": \"热门提问8\"},{\"question\": \"热门提问9\"},{\"question\": \"热门提问10\"}],\"total\": 10,\"total_page\": 1,\"page_no\": 1,\"page_size\": 10}";
        pageResult = JSON.parseObject(json, PageResult.class);
        return ApiResponse.ok(pageResult);
    }

    @Operation(summary = "历史对话")
    @GetMapping("/history")
    public ApiResponse<PageResult<UserChatCompletionMobileDto>> history(@Parameter(hidden = true) UserPrincipal userPrincipal,
                                                                        @QueryParam UserQaHistoryRequestDto request) {

        PageResult<UserChatCompletionMobileDto> pageResult = chatCompletionService.userQaHistoryPaginQuery(userPrincipal, request);
        return ApiResponse.ok(pageResult);
    }


    @Operation(summary = "用户提问")
    @PostMapping("/ask")
    public ApiResponse<UserAskResultMobileDto> ask(@Parameter(hidden = true) UserPrincipal userPrincipal,
                                                   @RequestBody UserQaMobileRequestDto request) {
        UserAskResultMobileDto result = chatCompletionService.userAsk(userPrincipal, request);
        return ApiResponse.ok(result);
    }

    @Operation(summary = "切换助手")
    @PostMapping("/assistant/switch")
    public ApiResponse<String> switchAssistant(@Parameter(hidden = true) UserPrincipal userPrincipal,
                                               @RequestBody SwitchAssistantMobileRequestDto request) {

        return ApiResponse.ok("ok");
    }

    @Operation(summary = "开启新会话，返回新会话ID")
    @PostMapping("/new_completion")
    public ApiResponse<NewCompletionResultMobileDto> newChatCompletion(@Parameter(hidden = true) UserPrincipal userPrincipal) {
        NewCompletionResultMobileDto result = new NewCompletionResultMobileDto();
        result.setChatCompletionId(1);
        return ApiResponse.ok(result);
    }

    @Operation(summary = "历史对话详情")
    @GetMapping("/history/detail")
    public ApiResponse<PageResult<UserChatCompletionHistoryMobileDto>> historyDetail(@Parameter(hidden = true) UserPrincipal userPrincipal,
                                                                                     @Schema(description = "历史会话ID") @RequestParam("chat_completion_id") Integer chatCompletionId,
                                                                                     @Schema(description = "页码") @RequestParam("page_no") Integer pageNo,
                                                                                     @Schema(description = "分页数量") @RequestParam("page_size") Integer pageSize) {

        PageResult<UserChatCompletionHistoryMobileDto> pageResult = chatCompletionService.userQaHistoryMobilePaginQuery(userPrincipal, chatCompletionId, pageNo, pageSize);
        return ApiResponse.ok(pageResult);
    }
}
