package cn.breeze.elleai.controller.front;

import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.util.UserPrincipal;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/front/user")
@Tag(name = "移动端-用户&授权")
@RequiredArgsConstructor
public class UserMobileController {

    @Operation(summary = "获取token")
    @GetMapping("/get_token")
    public ApiResponse<String> getToken() {
        //todo  移除mock数据，通过cookie获取返回
        return ApiResponse.ok("eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJqb2JUaXRsZSI6IuengeS6uumhvumXriIsImlzcyI6Im9zcyIsInNob3BOYW1lIjoi5p2P5Z2b5a6P5rGH5Z-O5bqXIiwicG9zaXRpb24iOiLpob7pl64iLCJzaG9wSWQiOiIwMDAwMDAwMDZlODY2OTVlMDE2ZTg2ZDJiYTkyMDAwOCIsInVzZXJOYW1lIjoiTTAwODg3NyIsImV4cCI6MTgxMTY3NDQ5NCwidXNlcklkIjoiMDAwMDAwMDA2MmQ3NWRiNTAxNjJkNzc1YjYxOTAwMGEifQ.4XCYKRVuHTaP3TYob7O31bpPnhoBQ9XSq1inM93IqYE");
    }


    @Operation(summary = "获取用户信息")
    @GetMapping("/info")
    public ApiResponse<UserPrincipal> getUserInfo(UserPrincipal userPrincipal) {
        return ApiResponse.ok(userPrincipal);
    }

}
