package cn.breeze.elleai.controller.front;


import cn.breeze.elleai.application.dto.ApiResponse;
import cn.breeze.elleai.application.dto.PageResult;
import cn.breeze.elleai.application.dto.request.*;
import cn.breeze.elleai.application.dto.response.*;
import cn.breeze.elleai.application.service.AppExamineService;
import cn.breeze.elleai.config.QueryParam;
import cn.breeze.elleai.util.UserPrincipal;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/front/wiki")
@Tag(name = "移动端-资料知识库")
@RequiredArgsConstructor
public class WikiMobileController {

    private final AppExamineService examineService;

    @Operation(summary = "获取资料分类列表")
    @GetMapping("/category/list")
    public ApiResponse<PageResult<WikiCategoryMobileDto>> list(
            @Parameter(hidden = true) UserPrincipal userPrincipal,
            @QueryParam WikiCategoryRequestDto request) {
        PageResult<WikiCategoryMobileDto> pageResult = examineService.wikiCategoryMobilePaginQuery(request);
        return ApiResponse.ok(pageResult);
    }

    @Operation(summary = "获取资料列表(分类+名称搜索)")
    @GetMapping("/list")
    public ApiResponse<PageResult<WikiListMobileDto>> list(
            @Parameter(hidden = true) UserPrincipal userPrincipal,
            @QueryParam WikiRequestDto request) {
        PageResult<WikiListMobileDto> pageResult = examineService.wikiMobilePaginQuery(request);
        return ApiResponse.ok(pageResult);
    }

    @Operation(summary = "获取资料详情")
    @GetMapping("/detail/{id}")
    public ApiResponse<WikiMobileDto> detail(@Schema(description = "资料ID") @PathVariable("id") Integer id) {
        WikiMobileDto detail = examineService.wikiMobileDetail(id);
        return ApiResponse.ok(detail);
    }
}
