package cn.breeze.elleai.domain.sparring.model.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class ExamineSaveModel implements Serializable {

    private Integer id;

    /**
     * 对练名称
     */
    private String name;

    /**
     * 对练描述
     */
    private String description;

    /**
     * 海报图
     */
    private String poster;

    /**
     * 对练场景ID
     */
    @JsonProperty("scene_id")
    private Integer sceneId;

    /**
     * 对练分类ID
     */
    @JsonProperty("category_id")
    private Integer categoryId;

    /**
     * 开始时间
     */
    @JsonProperty("start_time")
    private Date startTime;

    /**
     * 结束时间
     */
    @JsonProperty("end_time")
    private Date endTime;

    /**
     * 状态（0禁用 1启用）
     */
    private Integer status;

    /**
     * 题目数量
     */
    @JsonProperty("qa_num")
    private Integer qaNum;
    
}
