package cn.breeze.elleai.domain.sparring.model.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExamineSceneCategorySaveModel implements Serializable {

    private Integer id;

    /**
     * 分类名称
     */
    private String name;

    /**
     * 场景ID描述
     */
    @JsonProperty("scene_id")
    private Integer sceneId;

    /**
     * 可见角色IDS
     */
    @JsonProperty("visible_role_ids")
    private String visibleRoleIds;

    /**
     * 分类描述
     */
    private String description;

    /**
     * 状态（0禁用 1启用）
     */
    private Integer status;

    /**
     * 是否删除（0否 1是）
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    @JsonProperty("create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @JsonProperty("update_time")
    private Date updateTime;

    /**
     * 父级分类ID
     */
    @JsonProperty("parent_id")
    private Integer parentId;
    
}
