package cn.breeze.elleai.domain.sparring.model.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class ExamineResponseModel implements Serializable {

    
    private Integer id;

    /**
     * 对练名称
     */
    private String name;

    /**
     * 对练描述
     */
    private String description;

    /**
     * 海报图
     */
    private String poster;

    /**
     * 对练场景ID
     */
    private Integer sceneId;

    /**
     * 对练分类ID
     */
    private Integer categoryId;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 状态（0禁用 1启用）
     */
    private Integer status;

    /**
     * 题目数量
     */
    private Integer qaNum;

    /**
     * 是否删除（0否 1是）
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 关联题目列表
     */
    private List<ExamineQaResponseModel> qaList;
}
