package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.domain.sparring.model.request.*;
import cn.breeze.elleai.domain.sparring.model.response.QaAssistantResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.UserChatCompletionHistoryResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.UserChatCompletionResponseModel;
import com.mybatisflex.core.paginate.Page;

import java.util.List;

public interface ChatCompletionService {

    /***************************************** AI问答 *****************************************/
    Page<UserChatCompletionResponseModel> userQaPaginQuery(UserQaRequestModel request);

    Page<UserChatCompletionHistoryResponseModel> userQaHistoryPaginQuery(UserQaHistoryRequestModel request);

    List<UserChatCompletionResponseModel> userQaList(UserQaRequestModel request);

    List<UserChatCompletionHistoryResponseModel> userQaHistoryDetail(Integer chatCompletionId);

    Page<UserChatCompletionHistoryResponseModel> userQaHistoryDetailPaginQuery(Integer chatCompletionId, Integer pageNo, Integer pageSize);

    UserChatCompletionResponseModel userQaDetail(UserQaRequestModel request);

    Integer saveUserQaSession(UserChatCompletionSaveModel dto);

    void saveUserQaRecord(Integer chatCompletionId, Integer type, String content);

    /***************************************** AI助手 *****************************************/
    Page<QaAssistantResponseModel> qaAssistantPaginQuery(QaAssistantRequestModel request);

    List<QaAssistantResponseModel> qaAssistantList(QaAssistantRequestModel request);

    QaAssistantResponseModel qaAssistantDetail(Integer id);

    void updateQaAssistantStatus(Integer id, Integer status);

    void deleteQaAssistant(Integer id);

    void saveQaAssistant(QaAssistantSaveModel dto);
}
