package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.domain.sparring.model.request.*;
import cn.breeze.elleai.domain.sparring.model.response.QaAssistantResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.UserChatCompletionHistoryResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.UserChatCompletionResponseModel;
import cn.breeze.elleai.infra.entity.ExamineEntity;
import cn.breeze.elleai.infra.entity.QaAssistantEntity;
import cn.breeze.elleai.infra.entity.UserChatCompletionEntity;
import cn.breeze.elleai.infra.entity.UserChatCompletionHistoryEntity;
import cn.breeze.elleai.infra.mapper.QaAssistantMapper;
import cn.breeze.elleai.infra.mapper.UserChatCompletionHistoryMapper;
import cn.breeze.elleai.infra.mapper.UserChatCompletionMapper;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.update.UpdateChain;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

import static cn.breeze.elleai.infra.entity.table.QaAssistantTableDef.QA_ASSISTANT_ENTITY;
import static cn.breeze.elleai.infra.entity.table.UserChatCompletionHistoryTableDef.USER_CHAT_COMPLETION_HISTORY_ENTITY;
import static cn.breeze.elleai.infra.entity.table.UserChatCompletionTableDef.USER_CHAT_COMPLETION_ENTITY;


@Service
@RequiredArgsConstructor
public class ChatCompletionServiceImpl implements ChatCompletionService{

    private final UserChatCompletionHistoryMapper chatCompletionHistoryMapper;

    private final UserChatCompletionMapper chatCompletionMapper;

    private final QaAssistantMapper qaAssistantMapper;

    @Override
    public Page<UserChatCompletionResponseModel> userQaPaginQuery(UserQaRequestModel request) {
        Integer pageNo = ObjectUtil.defaultIfNull(request.getPageNo(), 1);
        Integer pageSize = ObjectUtil.defaultIfNull(request.getPageSize(), 10);

        QueryWrapper queryWrapper = QueryWrapper.create();
        if(StrUtil.isNotEmpty(request.getUserId())) {
            queryWrapper.where(USER_CHAT_COMPLETION_ENTITY.USER_ID.eq(request.getUserId()));
        }
        queryWrapper.orderBy(USER_CHAT_COMPLETION_ENTITY.CREATE_TIME, false);

        Page<UserChatCompletionResponseModel> page = chatCompletionMapper.paginateAs(pageNo, pageSize, queryWrapper, UserChatCompletionResponseModel.class);

        return page;
    }

    @Override
    public Page<UserChatCompletionHistoryResponseModel> userQaHistoryPaginQuery(UserQaHistoryRequestModel request) {
        Integer pageNo = ObjectUtil.defaultIfNull(request.getPageNo(), 1);
        Integer pageSize = ObjectUtil.defaultIfNull(request.getPageSize(), 10);

        QueryWrapper queryWrapper = QueryWrapper.create();
        if(Objects.nonNull(request.getChatCompletionId())) {
            queryWrapper.where(USER_CHAT_COMPLETION_HISTORY_ENTITY.CHAT_COMPLETION_ID.eq(request.getChatCompletionId()));
        }
        if(CollectionUtil.isNotEmpty(request.getChatCompletionIdList())) {
            queryWrapper.where(USER_CHAT_COMPLETION_HISTORY_ENTITY.CHAT_COMPLETION_ID.in(request.getChatCompletionIdList()));
        }
        if(Objects.nonNull(request.getType())) {
            queryWrapper.where(USER_CHAT_COMPLETION_HISTORY_ENTITY.TYPE.eq(request.getType()));
        }
        queryWrapper.orderBy(USER_CHAT_COMPLETION_HISTORY_ENTITY.CREATE_TIME, false);

        Page<UserChatCompletionHistoryResponseModel> page = chatCompletionHistoryMapper.paginateAs(pageNo, pageSize, queryWrapper, UserChatCompletionHistoryResponseModel.class);

        return page;
    }

    @Override
    public List<UserChatCompletionResponseModel> userQaList(UserQaRequestModel request) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        if(StrUtil.isNotEmpty(request.getUserId())) {
            queryWrapper.where(USER_CHAT_COMPLETION_ENTITY.USER_ID.eq(request.getUserId()));
        }
        return chatCompletionMapper.selectListByQueryAs(queryWrapper, UserChatCompletionResponseModel.class);
    }

    @Override
    public List<UserChatCompletionHistoryResponseModel> userQaHistoryDetail(Integer chatCompletionId) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        queryWrapper.where(USER_CHAT_COMPLETION_HISTORY_ENTITY.CHAT_COMPLETION_ID.eq(chatCompletionId));
        queryWrapper.orderBy(USER_CHAT_COMPLETION_HISTORY_ENTITY.CREATE_TIME, true);

        return chatCompletionHistoryMapper.selectListByQueryAs(queryWrapper, UserChatCompletionHistoryResponseModel.class);
    }

    @Override
    public Page<UserChatCompletionHistoryResponseModel> userQaHistoryDetailPaginQuery(Integer chatCompletionId, Integer pageNo, Integer pageSize) {

        QueryWrapper queryWrapper = QueryWrapper.create();
        queryWrapper.where(USER_CHAT_COMPLETION_HISTORY_ENTITY.CHAT_COMPLETION_ID.eq(chatCompletionId));
        queryWrapper.orderBy(USER_CHAT_COMPLETION_HISTORY_ENTITY.CREATE_TIME, true);

        Page<UserChatCompletionHistoryResponseModel> page = chatCompletionHistoryMapper.paginateAs(pageNo, pageSize, queryWrapper, UserChatCompletionHistoryResponseModel.class);

        return page;
    }

    @Override
    public UserChatCompletionResponseModel userQaDetail(UserQaRequestModel request) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        queryWrapper.where(USER_CHAT_COMPLETION_ENTITY.USER_ID.eq(request.getUserId()));
        queryWrapper.where(USER_CHAT_COMPLETION_ENTITY.SESSION_ID.eq(request.getSessionId()));
        queryWrapper.orderBy(USER_CHAT_COMPLETION_ENTITY.CREATE_TIME, false);
        return chatCompletionMapper.selectOneByQueryAs(queryWrapper, UserChatCompletionResponseModel.class);
    }

    @Override
    public Integer saveUserQaSession(UserChatCompletionSaveModel dto) {
        UserChatCompletionEntity entity = new UserChatCompletionEntity();
        BeanUtil.copyProperties(dto, entity);
        entity.setUpdateTime(new Date());
        chatCompletionMapper.insertOrUpdateSelective(entity);
        return entity.getId();
    }

    @Override
    public void saveUserQaRecord(Integer chatCompletionId, Integer type, String content) {
        UserChatCompletionHistoryEntity entity = new UserChatCompletionHistoryEntity();
        entity.setChatCompletionId(chatCompletionId);
        entity.setType(type);
        entity.setContent(content);
        entity.setCreateTime(new Date());
        chatCompletionHistoryMapper.insertOrUpdateSelective(entity);
    }

    @Override
    public Page<QaAssistantResponseModel> qaAssistantPaginQuery(QaAssistantRequestModel request) {

        Integer pageNo = ObjectUtil.defaultIfNull(request.getPageNo(), 1);
        Integer pageSize = ObjectUtil.defaultIfNull(request.getPageSize(), 10);

        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(QA_ASSISTANT_ENTITY.DELETED.eq(0));
        if(StrUtil.isNotEmpty(request.getName())) {
            queryWrapper.where(QA_ASSISTANT_ENTITY.NAME.like("%"+request.getName()+"%"));
        }
        queryWrapper.orderBy(QA_ASSISTANT_ENTITY.CREATE_TIME, false);

        Page<QaAssistantResponseModel> page = qaAssistantMapper.paginateAs(pageNo, pageSize, queryWrapper, QaAssistantResponseModel.class);

        return page;
    }

    @Override
    public List<QaAssistantResponseModel> qaAssistantList(QaAssistantRequestModel request) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(QA_ASSISTANT_ENTITY.DELETED.eq(0));
        if(StrUtil.isNotEmpty(request.getName())) {
            queryWrapper.where(QA_ASSISTANT_ENTITY.NAME.like("%"+request.getName()+"%"));
        }
        queryWrapper.orderBy(QA_ASSISTANT_ENTITY.CREATE_TIME, false);

        return qaAssistantMapper.selectListByQueryAs(queryWrapper, QaAssistantResponseModel.class);
    }

    @Override
    public QaAssistantResponseModel qaAssistantDetail(Integer id) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(QA_ASSISTANT_ENTITY.ID.eq(id).and(QA_ASSISTANT_ENTITY.DELETED.eq(0)));
        return qaAssistantMapper.selectOneByQueryAs(queryWrapper, QaAssistantResponseModel.class);
    }

    @Override
    public void updateQaAssistantStatus(Integer id, Integer status) {
        UpdateChain.of(QaAssistantEntity.class)
                .set(QA_ASSISTANT_ENTITY.STATUS, status)
                .set(QA_ASSISTANT_ENTITY.UPDATE_TIME, new Date())
                .where(QA_ASSISTANT_ENTITY.ID.eq(id))
                .update();
    }

    @Override
    public void deleteQaAssistant(Integer id) {
        UpdateChain.of(QaAssistantEntity.class)
                .set(QA_ASSISTANT_ENTITY.DELETED, 1)
                .set(QA_ASSISTANT_ENTITY.UPDATE_TIME, new Date())
                .where(QA_ASSISTANT_ENTITY.ID.eq(id))
                .update();
    }

    @Override
    public void saveQaAssistant(QaAssistantSaveModel dto) {
        QaAssistantEntity entity = BeanUtil.toBean(dto, QaAssistantEntity.class);
        entity.setUpdateTime(new Date());
        if(Objects.isNull(entity.getId())) {
            entity.setStatus(0);
            entity.setDeleted(0);
        }
        qaAssistantMapper.insertOrUpdateSelective(entity);
    }
}
