package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.domain.sparring.model.request.ExamineEvaluateJobSaveModel;
import cn.breeze.elleai.domain.sparring.model.request.ProperNounRequestModel;
import cn.breeze.elleai.domain.sparring.model.request.ProperNounSaveModel;
import cn.breeze.elleai.domain.sparring.model.response.DataDicResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.ExamineEvaluateJobResponseModel;
import cn.breeze.elleai.domain.sparring.model.response.ProperNounResponseModel;
import cn.breeze.elleai.infra.entity.ExamineEvaluateJobEntity;
import cn.breeze.elleai.infra.entity.ProperNounEntity;
import cn.breeze.elleai.infra.mapper.DataDicMapper;
import cn.breeze.elleai.infra.mapper.ExamineEvaluateJobMapper;
import cn.breeze.elleai.infra.mapper.ProperNounMapper;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.update.UpdateChain;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

import static cn.breeze.elleai.infra.entity.table.ProperNounTableDef.PROPER_NOUN_ENTITY;
import static cn.breeze.elleai.infra.entity.table.ExamineEvaluateJobTableDef.EXAMINE_EVALUATE_JOB_ENTITY;
import static cn.breeze.elleai.infra.entity.table.DataDicTableDef.DATA_DIC_ENTITY;


@Service
@RequiredArgsConstructor
public class CommonServiceImpl implements CommonService{

    private final ProperNounMapper properNounMapper;

    private final ExamineEvaluateJobMapper evaluateJobMapper;

    private final DataDicMapper dataDicMapper;

    @Override
    public Page<ProperNounResponseModel> properNounPaginQuery(ProperNounRequestModel request) {
        Integer pageNo = ObjectUtil.defaultIfNull(request.getPageNo(), 1);
        Integer pageSize = ObjectUtil.defaultIfNull(request.getPageSize(), 10);

        QueryWrapper queryWrapper = QueryWrapper.create();
        queryWrapper.where(PROPER_NOUN_ENTITY.DELETED.eq(0));
        if(StrUtil.isNotEmpty(request.getName())) {
            queryWrapper.where(PROPER_NOUN_ENTITY.NAME.like("%"+request.getName()+"%"));
        }
        queryWrapper.orderBy(PROPER_NOUN_ENTITY.CREATE_TIME, false);

        Page<ProperNounResponseModel> page = properNounMapper.paginateAs(pageNo, pageSize, queryWrapper, ProperNounResponseModel.class);

        return page;
    }

    @Override
    public List<ProperNounResponseModel> properNounList(ProperNounRequestModel request) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        queryWrapper.where(PROPER_NOUN_ENTITY.DELETED.eq(0));
        if(StrUtil.isNotEmpty(request.getName())) {
            queryWrapper.where(PROPER_NOUN_ENTITY.NAME.like("%"+request.getName()+"%"));
        }
        queryWrapper.orderBy(PROPER_NOUN_ENTITY.CREATE_TIME, false);

        return properNounMapper.selectListByQueryAs(queryWrapper, ProperNounResponseModel.class);
    }

    @Override
    public ProperNounResponseModel properNounDetail(Integer id) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(PROPER_NOUN_ENTITY.ID.eq(id).and(PROPER_NOUN_ENTITY.DELETED.eq(0)));
        return properNounMapper.selectOneByQueryAs(queryWrapper, ProperNounResponseModel.class);
    }

    @Override
    public void updateProperNounStatus(Integer id, Integer status) {
        UpdateChain.of(ProperNounEntity.class)
                .set(PROPER_NOUN_ENTITY.STATUS, status)
                .set(PROPER_NOUN_ENTITY.UPDATE_TIME, new Date())
                .where(PROPER_NOUN_ENTITY.ID.eq(id))
                .update();
    }

    @Override
    public void deleteProperNoun(Integer id) {
        UpdateChain.of(ProperNounEntity.class)
                .set(PROPER_NOUN_ENTITY.DELETED, 1)
                .set(PROPER_NOUN_ENTITY.UPDATE_TIME, new Date())
                .where(PROPER_NOUN_ENTITY.ID.eq(id))
                .update();
    }

    @Override
    public void saveProperNoun(ProperNounSaveModel dto) {
        ProperNounEntity entity = BeanUtil.toBean(dto, ProperNounEntity.class);
        entity.setUpdateTime(new Date());
        if(Objects.isNull(entity.getId())) {
            entity.setStatus(0);
            entity.setDeleted(0);
        }
        properNounMapper.insertOrUpdateSelective(entity);
    }

    @Override
    public void saveEvaluateJob(ExamineEvaluateJobSaveModel dto) {
        ExamineEvaluateJobEntity entity = BeanUtil.toBean(dto, ExamineEvaluateJobEntity.class);
        entity.setUpdateTime(new Date());
        if(Objects.isNull(entity.getId())) {
            entity.setStatus(0);
        }
        evaluateJobMapper.insertOrUpdateSelective(entity);
    }

    @Override
    public ExamineEvaluateJobResponseModel getEvaluateJob(Integer type, Integer businessId) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(EXAMINE_EVALUATE_JOB_ENTITY.TYPE.eq(type)
                        .and(EXAMINE_EVALUATE_JOB_ENTITY.BUSINESS_ID.eq(businessId)));
        return evaluateJobMapper.selectOneByQueryAs(queryWrapper, ExamineEvaluateJobResponseModel.class);
    }

    @Override
    public List<ExamineEvaluateJobResponseModel> pendingEvaluateJobList() {

        QueryWrapper queryWrapper = QueryWrapper.create();
        queryWrapper.where(EXAMINE_EVALUATE_JOB_ENTITY.STATUS.eq(0));
        queryWrapper.orderBy(EXAMINE_EVALUATE_JOB_ENTITY.CREATE_TIME, true);

        return evaluateJobMapper.selectListByQueryAs(queryWrapper, ExamineEvaluateJobResponseModel.class);
    }

    @Override
    public DataDicResponseModel getDataDicByCode(String dataCode) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .where(DATA_DIC_ENTITY.DATA_CODE.eq(dataCode));
        return dataDicMapper.selectOneByQueryAs(queryWrapper, DataDicResponseModel.class);
    }
}
