package cn.breeze.elleai.domain.sparring.service;

import cn.breeze.elleai.domain.sparring.model.request.*;
import cn.breeze.elleai.domain.sparring.model.response.*;
import cn.hutool.db.PageResult;
import com.mybatisflex.core.paginate.Page;

import java.util.List;

/**
 *  服务层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public interface ExamineService {

    Page<ExamineSceneResponseModel> scenePaginQuery(ExamineSceneRequestModel request);

    Page<ExamineSceneCategoryResponseModel> sceneCategoryPaginQuery(ExamineSceneCategoryRequestModel request);

    /**
     * 场景列表
     * @return
     */
    List<ExamineSceneResponseModel> sceneList(ExamineSceneRequestModel request);

    List<ExamineSceneCategoryResponseModel> sceneCategoryList(ExamineSceneCategoryRequestModel request);

    ExamineSceneResponseModel sceneDetail(Integer sceneId);

    ExamineSceneCategoryResponseModel sceneCategoryDetail(Integer sceneCategoryId);

    void updateSceneStatus(Integer sceneId, Integer status);

    void updateSceneCategoryStatus(Integer sceneCategoryId, Integer status);

    void deleteScene(Integer sceneId);

    void deleteSceneCategory(Integer sceneCategoryId);

    void saveScene(ExamineSceneSaveModel dto);

    void saveSceneCategory(ExamineSceneCategorySaveModel dto);

    /**
     * 题目分页查询
     * @return
     */
    Page<ExamineQaResponseModel> examineQaPaginQuery(ExamineQaRequestModel request);

    List<ExamineQaResponseModel> examineQaList(Integer examineId);

    List<ExamineQaResponseModel> examineQaList(List<Integer> qaIds);

    ExamineQaResponseModel examineQaDetail(Integer qaId);

    void updateExamineQaStatus(Integer qaId, Integer status);

    void deleteExamineQa(Integer qaId);

    void saveExamineQa(ExamineQaSaveModel dto);

    /***************************************** 对练 *****************************************/
    Page<ExamineResponseModel> examinePaginQuery(ExamineRequestModel request);

    List<ExamineResponseModel> examineList(ExamineRequestModel request);

    ExamineResponseModel examineDetail(Integer examineId);

    void updateExamineStatus(Integer examineId, Integer status);

    void deleteExamine(Integer examineId);

    void saveExamine(ExamineSaveModel dto);

    /***************************************** 对练题目关联 *****************************************/
    List<ExamineQaXrefResponseModel> examineQaXrefList(Integer examineId);

    void deleteExamineQaXref(Integer examineId);

    void saveExamineQaXref(Integer examineId, List<Integer> qaIdList);


    /***************************************** 对练记录 *****************************************/
    Page<ExamineRecordResponseModel> examineRecordPaginQuery(ExamineRecordRequestModel request);

    Page<ExamineRecordResponseModel> examineRecordMobilePaginQuery(ExamineRecordRequestModel request);

    List<ExamineRecordResponseModel> examineRecordList(ExamineRecordRequestModel request);


    List<ExamineDetailRecordResponseModel> examineDetailRecordList(ExamineDetailRecordRequestModel request);

    ExamineRecordResponseModel examineRecordDetail(Integer id);

    ExamineRecordResponseModel examineRecordDetail(String businessNo);

    void saveExamineRecord(ExamineRecordSaveModel dto);

    void saveExamineRecordDetail(ExamineRecordDetailSaveModel dto);

    ExamineRecordDetailResponseModel singleExamineQaDetail(Integer id);

    long countUnfinishedExamineRecord(Integer examineId);


    /***************************************** 资料库分类 *****************************************/
    Page<WikiCategoryResponseModel> wikiCategoryPaginQuery(WikiCategoryRequestModel request);

    List<WikiCategoryResponseModel> wikiCategoryList(WikiCategoryRequestModel request);

    WikiCategoryResponseModel wikiCategoryDetail(Integer id);

    void updateWikiCategoryStatus(Integer id, Integer status);

    void deleteWikiCategory(Integer id);

    void saveWikiCategory(WikiCategorySaveModel dto);

    Page<WikiResponseModel> wikiPaginQuery(WikiRequestModel request);

    List<WikiResponseModel> wikiList(WikiRequestModel request);

    WikiResponseModel wikiDetail(Integer id);

    void updateWikiStatus(Integer id, Integer status);

    void deleteWiki(Integer id);

    void saveWiki(WikiSaveModel dto);
}
