package cn.breeze.elleai.exception;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

/**
 *
 * 内部异常类
 * @author Administrator
 */
@Getter
@Setter
public class InternalException extends RuntimeException {

    public InternalException() {
        super();
    }

    public InternalException(int code, String description) {
        super();
        this.code = code;
        this.description = description;
    }

    /**
     * 错误码
     */
    @Schema(description = "错误编码")
    private int code;


    /**
     * 错误信息描述
     */
    @Schema(description = "错误描述")
    private String description;

}
