package cn.breeze.elleai.infra.entity;

import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import java.io.Serializable;
import java.util.Date;

import java.io.Serial;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *  实体类。
 *
 * @author breeze
 * @since 2024-09-18
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table("ai_examine_scene_category")
public class ExamineSceneCategoryEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    @Id(keyType = KeyType.Auto)
    private Integer id;

    /**
     * 分类名称
     */
    private String name;

    /**
     * 场景ID描述
     */
    private Integer sceneId;

    /**
     * 可见角色IDS
     */
    private String visibleRoleIds;

    /**
     * 分类描述
     */
    private String description;

    /**
     * 状态（0禁用 1启用）
     */
    private Integer status;

    /**
     * 是否删除（0否 1是）
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 父级分类ID
     */
    private Integer parentId;

}
