package cn.breeze.elleai.infra.entity;

import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import java.io.Serializable;
import java.util.Date;

import java.io.Serial;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *  实体类。
 *
 * @author breeze
 * @since 2024-09-18
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table("ai_user_examine_record")
public class UserExamineRecordEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    @Id(keyType = KeyType.Auto)
    private Integer id;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 考试流水号
     */
    private String businessNo;

    /**
     * 所属门店ID
     */
    private String shopId;

    /**
     * 所属门店名称
     */
    private String shopName;

    /**
     * 会话ID
     */
    private String sessionId;

    /**
     * 对练ID
     */
    private Integer examineId;

    /**
     * 对练模式（0练习 1对练）
     */
    private Integer examineMode;

    /**
     * 已答题数量
     */
    private Integer answeredNum;

    /**
     * 综合评分
     */
    private Float overallScore;

    /**
     * 综合评价
     */
    private String overallEvaluation;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 是否删除
     */
    private Integer deleted;

}
