package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class DataDicTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    public static final DataDicTableDef DATA_DIC_ENTITY = new DataDicTableDef();


    public final QueryColumn ID = new QueryColumn(this, "id");

    public final QueryColumn DATA_CODE = new QueryColumn(this, "data_code");

    public final QueryColumn DATA_VALUE = new QueryColumn(this, "data_value");

    public final QueryColumn DESCRIPTION = new QueryColumn(this, "description");

    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");


    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, DATA_CODE, DATA_VALUE, DESCRIPTION, CREATE_TIME};

    public DataDicTableDef() {
        super("", "ai_data_dic");
    }

    private DataDicTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public DataDicTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new DataDicTableDef("", "ai_data_dic", alias));
    }

}
