package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class ExamineQaTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final ExamineQaTableDef EXAMINE_QA_ENTITY = new ExamineQaTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 答案
     */
    public final QueryColumn ANSWER = new QueryColumn(this, "answer");

    /**
     * 状态（0禁用 1启用）
     */
    public final QueryColumn STATUS = new QueryColumn(this, "status");

    /**
     * 是否删除（0否 1是）
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 问题
     */
    public final QueryColumn QUESTION = new QueryColumn(this, "question");

    /**
     * 对练分类ID
     */
    public final QueryColumn CATEGORY_ID = new QueryColumn(this, "category_id");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, QUESTION, ANSWER, CATEGORY_ID, STATUS, DELETED, CREATE_TIME, UPDATE_TIME};

    public ExamineQaTableDef() {
        super("", "ai_examine_qa");
    }

    private ExamineQaTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public ExamineQaTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new ExamineQaTableDef("", "ai_examine_qa", alias));
    }

}
