package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class ExamineQaXrefTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final ExamineQaXrefTableDef EXAMINE_QA_XREF_ENTITY = new ExamineQaXrefTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 题目ID
     */
    public final QueryColumn QA_ID = new QueryColumn(this, "qa_id");

    /**
     * 是否删除（0否 1是）
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 对练ID
     */
    public final QueryColumn EXAMINE_ID = new QueryColumn(this, "examine_id");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, EXAMINE_ID, QA_ID, DELETED, CREATE_TIME, UPDATE_TIME};

    public ExamineQaXrefTableDef() {
        super("", "ai_examine_qa_xref");
    }

    private ExamineQaXrefTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public ExamineQaXrefTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new ExamineQaXrefTableDef("", "ai_examine_qa_xref", alias));
    }

}
