package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class ExamineSceneCategoryTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final ExamineSceneCategoryTableDef EXAMINE_SCENE_CATEGORY_ENTITY = new ExamineSceneCategoryTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 分类名称
     */
    public final QueryColumn NAME = new QueryColumn(this, "name");

    /**
     * 状态（0禁用 1启用）
     */
    public final QueryColumn STATUS = new QueryColumn(this, "status");

    /**
     * 是否删除（0否 1是）
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 场景ID描述
     */
    public final QueryColumn SCENE_ID = new QueryColumn(this, "scene_id");

    /**
     * 父级分类ID
     */
    public final QueryColumn PARENT_ID = new QueryColumn(this, "parent_id");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 分类描述
     */
    public final QueryColumn DESCRIPTION = new QueryColumn(this, "description");

    /**
     * 可见角色IDS
     */
    public final QueryColumn VISIBLE_ROLE_IDS = new QueryColumn(this, "visible_role_ids");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, NAME, SCENE_ID, VISIBLE_ROLE_IDS, DESCRIPTION, STATUS, DELETED, CREATE_TIME, UPDATE_TIME, PARENT_ID};

    public ExamineSceneCategoryTableDef() {
        super("", "ai_examine_scene_category");
    }

    private ExamineSceneCategoryTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public ExamineSceneCategoryTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new ExamineSceneCategoryTableDef("", "ai_examine_scene_category", alias));
    }

}
