package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class ProperNounTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final ProperNounTableDef PROPER_NOUN_ENTITY = new ProperNounTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 专有名词名称
     */
    public final QueryColumn NAME = new QueryColumn(this, "name");

    /**
     * 状态（0禁用 1启用）
     */
    public final QueryColumn STATUS = new QueryColumn(this, "status");

    /**
     * 是否删除（0否 1是）
     */
    public final QueryColumn DELETED = new QueryColumn(this, "deleted");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 相似词列表
     */
    public final QueryColumn SIMILAR_WORDS = new QueryColumn(this, "similar_words");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, NAME, SIMILAR_WORDS, STATUS, DELETED, CREATE_TIME, UPDATE_TIME};

    public ProperNounTableDef() {
        super("", "ai_proper_noun");
    }

    private ProperNounTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public ProperNounTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new ProperNounTableDef("", "ai_proper_noun", alias));
    }

}
