package cn.breeze.elleai.infra.entity.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;

import java.io.Serial;

/**
 *  表定义层。
 *
 * @author breeze
 * @since 2024-09-18
 */
public class UserExamineDetailRecordTableDef extends TableDef {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public static final UserExamineDetailRecordTableDef USER_EXAMINE_DETAIL_RECORD_ENTITY = new UserExamineDetailRecordTableDef();

    
    public final QueryColumn ID = new QueryColumn(this, "id");

    /**
     * 题目ID
     */
    public final QueryColumn QA_ID = new QueryColumn(this, "qa_id");

    /**
     * 评分
     */
    public final QueryColumn SCORE = new QueryColumn(this, "score");

    /**
     * 对练记录ID
     */
    public final QueryColumn RECORD_ID = new QueryColumn(this, "record_id");

    /**
     * 创建时间
     */
    public final QueryColumn CREATE_TIME = new QueryColumn(this, "create_time");

    /**
     * 评价
     */
    public final QueryColumn EVALUATION = new QueryColumn(this, "evaluation");

    /**
     * 员工回答
     */
    public final QueryColumn ANSWER = new QueryColumn(this, "answer");

    /**
     * 更新时间
     */
    public final QueryColumn UPDATE_TIME = new QueryColumn(this, "update_time");

    /**
     * 所有字段。
     */
    public final QueryColumn ALL_COLUMNS = new QueryColumn(this, "*");

    /**
     * 默认字段，不包含逻辑删除或者 large 等字段。
     */
    public final QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{ID, RECORD_ID, QA_ID, SCORE, EVALUATION, ANSWER, CREATE_TIME, UPDATE_TIME};

    public UserExamineDetailRecordTableDef() {
        super("", "ai_user_examine_detail_record");
    }

    private UserExamineDetailRecordTableDef(String schema, String name, String alisa) {
        super(schema, name, alisa);
    }

    public UserExamineDetailRecordTableDef as(String alias) {
        String key = getNameWithSchema() + "." + alias;
        return getCache(key, k -> new UserExamineDetailRecordTableDef("", "ai_user_examine_detail_record", alias));
    }

}
