package cn.breeze.elleai.security;

import cn.breeze.elleai.util.JwtUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.web.servlet.HandlerInterceptor;
import reactor.core.publisher.Mono;

import java.util.*;

@Slf4j
public class JwtInterceptor implements HandlerInterceptor {

    @SneakyThrows
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String token = request.getHeader("token");
        if(StringUtils.isEmpty(token)){
            System.out.println("json不能为空");
        }
        Mono<Authentication> convert = JwtUtil.convert(request);
        Authentication authentication = convert.toFuture().get();
        if(Objects.isNull(authentication)) {
            response.setStatus(401);
            return false;
        }
        return true;
    }


}
