package cn.breeze.elleai.application.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 应用层的API响应包装类
 * @author Administrator
 */
@Data
@Schema(description = "API响应包装类")
public class ApiResponse <T> implements Serializable  {

    @Schema(description = "响应是否成功标志")
    private boolean success = true;

    @Schema(description = "响应结果")
    private T result;

    @Schema(description = "状态码，0成功，其他失败")
    private Integer code = 0;

    @Schema(description = "错误内容")
    private String message;


    /**
     * 成功响应
     * @param result
     * @return
     * @param <T>
     */
    public final static <T> ApiResponse<T>  ok(T result) {
        ApiResponse<T> response = new ApiResponse<>();
        response.setSuccess(true);
        response.setCode(0);
        response.setMessage("成功");
        response.setResult(result);
        return response;
    }

    /**
     * 失败响应
     * @param code
     * @param message
     * @return
     * @param <T>
     */
    public final static <T> ApiResponse<T> fail(Integer code, String message) {
        ApiResponse<T> response = new ApiResponse<>();
        response.setMessage(message);
        response.setCode(code);
        response.setSuccess(false);
        response.setResult(null);
        return response;
    }
}
