package cn.breeze.elleai.application.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class PageResult<T> implements Serializable {

    @Schema(description = "记录")
    private List<T> items;

    @Schema(description = "总数量")
    private Integer total;

    @Schema(description = "总页数")
    @JsonProperty("total_page")
    private Integer totalPage;

    @Schema(description = "页码")
    @JsonProperty("page_no")
    private Integer pageNo;

    @Schema(description = "分页大小")
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 构造
     * @param pageNo
     * @param pageSize
     * @param total
     * @param items
     * @param <T>
     * @return
     */
    public final static <T> PageResult<T> of(Integer pageNo, Integer pageSize, Integer total, List<T> items) {
        PageResult<T> pageResult = new PageResult<>();
        pageResult.setPageNo(pageNo);
        pageResult.setPageSize(pageSize);
        pageResult.setItems(items);
        pageResult.setTotal(total);
        pageResult.setTotalPage(total/pageSize + 1);
        return pageResult;
    }
}
