package cn.breeze.elleai.application.dto.langchain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author yangyw
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Schema(description = "rag搜索请求")
@NoArgsConstructor
public class RagSearchRequest extends VectorSearchRequest {

    @Schema(description = "是否启用rerank")
    private Boolean enableRerank;

    @Schema(description = "rerank结果数量")
    private Integer topKRerank;

    @Schema(description = "rerank最小相似度")
    private Double minScoreRerank;

}
