package cn.breeze.elleai.application.dto.langchain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author yangyw
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Schema(description = "rerank请求")
public class RerankRequest extends Target {

    @Schema(description = "返回数量")
    private Integer topN;

    @Schema(description = "阈值")
    private Double scoreThreshold;

    @Schema(description = "查询内容")
    private String query;

    @Schema(description = "待rerank的向量")
    private List<String> documents;
}
