package cn.breeze.elleai.application.dto.langchain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.util.Map;

/**
 * @author yangyw
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Schema(description = "向量搜索请求")
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class VectorSearchRequest extends Target {

    @Schema(description = "查询文本")
    private String query;

    @Schema(description = "返回结果数量")
    private Integer topK;

    @Schema(description = "最小相似度")
    private Double minScore;

    private Map<String, ?> metadata;
}
